package gov.va.med.mhv.usermgmt.main.registry;

import java.util.ArrayList;
import java.util.List;

public class Patient extends ModelObject {

    private String icn;
	private Long dfn;
	private List<Facility> facilities;
    private PersonalInfo personalInfo;
	
	public List<Facility> getFacilities() {
		if (facilities==null)
			facilities = new ArrayList<Facility>(3);
		return facilities;
	}
	public void setFacilities(List<Facility> facilities) {
		this.facilities = facilities;
	}
	public String getIcn() {
		return icn;
	}
	public void setIcn(String icn) {
		this.icn = icn;
	}
	public String getSsn() {
		return (personalInfo != null) ? personalInfo.getSsn() : null;
	}

    public Long getDfn() {
		return dfn;
	}
	public void setDfn(Long dfn) {
		this.dfn = dfn;
	}

    /**
     * @return Returns the personalInfo.
     */
    public PersonalInfo getPersonalInfo() {
        return personalInfo;
    }
    /**
     * @param personalInfo The personalInfo to set.
     */
    public void setPersonalInfo(PersonalInfo personalInfo) {
        this.personalInfo = personalInfo;
    }
    
    @Override
    public int hashCode() {
        final int PRIME = 7;
        int result = 1;
        // TODO: This code could overflow the maximum integer,
        // as the result can grow quickly, if any of the property 
        // hashcodes are big. 
        result = PRIME * result + hashCodeOrZero(facilities);
        result = PRIME * result + hashCodeOrZero(icn);
        result = PRIME * result + hashCodeOrZero(personalInfo);
        result = PRIME * result + hashCodeOrZero(dfn);
        return result;
    }


    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Patient other = (Patient) obj;
        return areEqual(facilities, other.facilities)
            && areEqual(icn, other.icn)
            && areEqual(personalInfo, other.personalInfo)
            && areEqual(dfn, other.dfn);
    }

}
